import Image from "next/image"
import Link from "next/link"
import MobileMenu from "./OnePageMobileMenu";

import logo from "@/assets/images/logo/logo.svg"

interface MobileSidebarProps {
   offCanvas: boolean;
   setOffCanvas: (offCanvas: boolean) => void;
    page: string;
}

const OnePageOffcanvas = ({page, offCanvas, setOffCanvas }: MobileSidebarProps) => {

   return (
      <>
         <div id="targetElement" className={`sidebar-area ${offCanvas ? "" : "sidebar__hide"}`}>
            <div onClick={() => setOffCanvas(false)} className="sidebar__overlay"></div>
            <Link href="/" className="logo mb-40">
               <Image src={logo} alt="logo" />
            </Link>
            <div className="sidebar__search mb-30">
               <input type="text" placeholder="Search..." />
               <i className="fa-regular fa-magnifying-glass"></i>
            </div>
            <div className="mobile-menu overflow-hidden mean-container">
               <div className="mean-bar">
                  <nav className="mean-nav">
                     <MobileMenu page={page} />
                  </nav>
               </div>
            </div>
            <ul className="info pt-40">
               <li><i className="fa-solid primary-color fa-location-dot"></i> <Link href="#">example@example.com</Link>
               </li>
               <li className="py-2"><i className="fa-solid primary-color fa-phone-volume"></i> <Link
                  href="tel:+208-6666-0112">+208-6666-0112</Link>
               </li>
               <li><i className="fa-solid primary-color fa-paper-plane"></i> <Link href="#">info@example.com</Link></li>
            </ul>
            <div className="social-icon mt-20">
               <Link href="#"><i className="fa-brands fa-facebook-f"></i></Link>
               <Link href="#"><i className="fa-brands fa-twitter"></i></Link>
               <Link href="#"><i className="fa-brands fa-linkedin-in"></i></Link>
               <Link href="#"><i className="fa-brands fa-youtube"></i></Link>
            </div>
            <button onClick={() => setOffCanvas(false)} id="closeButton" className="text-white"><i className="fa-solid fa-xmark"></i></button>
         </div>
      </>
   )
}

export default OnePageOffcanvas
