import { StaticImageData } from "next/image";

import img_1 from "@/assets/images/menu/home1-image.jpg"
import img_2 from "@/assets/images/menu/home2-image.jpg"
import img_3 from "@/assets/images/menu/home3-image.jpg"
import img_4 from "@/assets/images/menu/home4-image.jpg"

interface MenuItem {
    id: number;
    title: string;
    link: string;
    has_dropdown: boolean;
    mega_munu?: {
        id: number;
        img: StaticImageData;
        btn_1: string;
        btn_link1: string;
        btn_2?: string;
        btn_link2?: string;
        title: string;
    }[];
    sub_menus?: {
        link: string;
        title: string;
    }[];
}

const menu_data: MenuItem[] = [
    {
        id: 1,
        title: "Home",
        link: "#",
        has_dropdown: true,
        mega_munu: [
            {
                id: 1,
                img: img_1,
                btn_1: "Multi Page",
                btn_link1: "/",
                btn_2: "One Page",
                btn_link2: "/home-1-one-page",
                title: "Home Page 01"
            },
            {
                id: 2,
                img: img_2,
                btn_1: "Multi Page",
                btn_link1: "/home-two",
                btn_2: "One Page",
                btn_link2: "/home-2-one-page",
                title: "Home Page 01"
            },
            {
                id: 3,
                img: img_3,
                btn_1: "Multi Page",
                btn_link1: "/home-three",
                btn_2: "One Page",
                btn_link2: "/home-3-one-page",
                title: "Home Page 03"
            },
            {
                id: 4,
                img: img_4,
                btn_1: "View Page",
                btn_link1: "/dark-home",
                title: "Home Dark"
            },
        ],
    },
    {
        id: 2,
        has_dropdown: false,
        title: "About",
        link: "/about",
    },
    {
        id: 3,
        title: "Services",
        link: "#",
        has_dropdown: true,
        sub_menus: [
            { link: "/service-solutions", title: "IT Solutions" },
            { link: "/service", title: "IT Services" },
            { link: "/service-details", title: "Service Details" },
        ],
    },
    {
        id: 4,
        title: "Pages",
        link: "#",
        has_dropdown: true,
        sub_menus: [
            { link: "/case", title: "Case Study 01" },
            { link: "/case-2", title: "Case Study 02" },
            { link: "/case-details", title: "Case Study Details" },
            { link: "/team", title: "Our Team" },
            { link: "/team-details", title: "Team Details" },
            { link: "/pricing", title: "Pricing" },
            { link: "/faq", title: "FAQ's" },
            { link: "/not-found", title: "404 Error" },
        ],
    },
    {
        id: 5,
        title: "Blog",
        link: "#",
        has_dropdown: true,
        sub_menus: [
            { link: "/blog", title: "Blog Grid" },
            { link: "/blog-standard", title: "Blog Standard" },
            { link: "/blog-details", title: "Blog Details" },
        ],
    },
    {
        id: 6,
        has_dropdown: false,
        title: "Contact",
        link: "/contact",
    },
];

export default menu_data;