"use client"
import { useState } from "react";
import ReactPaginate from "react-paginate";
import Image from "next/image"
import Link from "next/link"
import bolg_data from "@/data/BlogData";
import BlogSidebar from "../blog-sidebar";

const BlogArea = () => {

   const blog = bolg_data.filter((items) => items.page === "blog_2");

   const itemsPerPage = 3;
   const [itemOffset, setItemOffset] = useState(0);
   const endOffset = itemOffset + itemsPerPage;
   const currentItems = blog.slice(itemOffset, endOffset);
   const pageCount = Math.ceil(blog.length / itemsPerPage);
   // click to request another page.
   const handlePageClick = (event: { selected: number }) => {
      const newOffset = (event.selected * itemsPerPage) % blog.length;
      setItemOffset(newOffset);
   };

   return (
      <section className="blog-single-area pt-120 pb-120">
         <div className="container">
            <div className="row g-4">
               <div className="col-lg-8 order-2 order-lg-1">
                  {currentItems.map((item) => (
                     <div key={item.id} className="blog-two__grid-item shadow-none mb-30">
                        <Link href="/blog-details" className="blog__image d-block image">
                           <Image src={item.thumb} alt="image" />
                           <div className="blog-tag">
                              <h3 className="text-white">{item.date}</h3>
                              <span className="text-white">{item.month}</span>
                           </div>
                        </Link>
                        <div className="blog__content">
                           <ul className="blog-info mb-20">
                              <li>
                                 <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clipPath="url(#clip0_880_270)">
                                       <path
                                          d="M8.05666 18.75H8.05504C7.46832 18.7495 6.91657 18.5207 6.50187 18.1052L0.660341 12.2553C-0.194072 11.3994 -0.194072 10.0065 0.660341 9.15058L8.53478 1.26102C9.3463 0.44792 10.426 0 11.575 0H16.5709C17.7824 0 18.7682 0.985546 18.7682 2.19726V7.17785C18.7682 8.32602 18.3208 9.40532 17.5084 10.2167L9.60951 18.1074C9.19455 18.5218 8.64306 18.75 8.05666 18.75ZM11.575 1.46484C10.8179 1.46484 10.1064 1.75998 9.57163 2.29579L1.69707 10.1853C1.41222 10.4708 1.41222 10.9349 1.69707 11.2203L7.53857 17.0702C7.6767 17.2086 7.86051 17.285 8.05619 17.2851H8.05677C8.1529 17.2854 8.24812 17.2666 8.33694 17.2299C8.42577 17.1931 8.50643 17.1391 8.57427 17.071L16.4732 9.18046C17.0086 8.6458 17.3034 7.93447 17.3034 7.17788V2.19726C17.3034 1.79341 16.9748 1.46484 16.5709 1.46484H11.575ZM13.458 7.43408C12.2465 7.43408 11.2608 6.44853 11.2608 5.23681C11.2608 4.0251 12.2465 3.03955 13.458 3.03955C14.6696 3.03955 15.6553 4.0251 15.6553 5.23681C15.6553 6.44853 14.6696 7.43408 13.458 7.43408ZM13.458 4.50439C13.0542 4.50439 12.7256 4.83296 12.7256 5.23681C12.7256 5.64067 13.0542 5.96924 13.458 5.96924C13.862 5.96924 14.1905 5.64067 14.1905 5.23681C14.1905 4.83296 13.862 4.50439 13.458 4.50439Z"
                                          fill="#3C72FC" />
                                    </g>
                                    <defs>
                                       <clipPath>
                                          <rect width="20" height="20" fill="white" />
                                       </clipPath>
                                    </defs>
                                 </svg>
                                 <Link href="#0">{item.category}</Link>
                              </li>
                              <li>
                                 <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clipPath="url(#clip0_615_71)">
                                       <path
                                          d="M18.752 14.443C20.6847 11.7314 20.3893 8.01637 17.7495 5.59641C16.5434 4.49074 15.0057 3.80242 13.3448 3.6102C13.3344 3.59727 13.3236 3.58479 13.3122 3.57277C11.8673 2.0718 9.79133 1.21094 7.61672 1.21094C3.47848 1.21094 0 4.29426 0 8.24219C0 9.62637 0.429961 10.9533 1.24672 12.0993L0.105742 15.6815C0.0706615 15.7916 0.0689221 15.9096 0.100743 16.0207C0.132563 16.1318 0.196522 16.231 0.284576 16.3058C0.37263 16.3807 0.480845 16.4278 0.595611 16.4413C0.710377 16.4548 0.826568 16.434 0.92957 16.3816L4.39937 14.6173C5.11195 14.9241 5.86758 15.1255 6.65008 15.2171C8.15953 16.8044 10.2467 17.6172 12.382 17.6172C13.492 17.6172 14.598 17.391 15.5992 16.961L19.0692 18.7254C19.1514 18.7673 19.2424 18.7891 19.3346 18.7891C19.73 18.7891 20.0135 18.4037 19.893 18.0253L18.752 14.443ZM4.63586 13.4383C4.5549 13.3999 4.46621 13.3805 4.37659 13.3817C4.28697 13.3829 4.19883 13.4047 4.11895 13.4453L1.64758 14.702L2.45461 12.1681C2.48356 12.0773 2.48989 11.9807 2.47305 11.8869C2.45622 11.793 2.41673 11.7047 2.35801 11.6295C1.58199 10.6362 1.1718 9.46488 1.1718 8.24219C1.1718 5.01133 4.06297 2.38281 7.61672 2.38281C9.04781 2.38281 10.4255 2.81637 11.543 3.59711C7.77945 3.97555 4.76531 6.91516 4.76531 10.5859C4.76531 11.7277 5.05797 12.8268 5.60973 13.8116C5.276 13.7123 4.95042 13.5876 4.63586 13.4383ZM15.8798 15.789C15.7999 15.7484 15.7118 15.7267 15.6222 15.7254C15.5325 15.7242 15.4438 15.7436 15.3629 15.7821C14.4494 16.216 13.4187 16.4453 12.382 16.4453C8.82828 16.4453 5.93711 13.8168 5.93711 10.5859C5.93711 7.35508 8.82828 4.72656 12.382 4.72656C15.9358 4.72656 18.827 7.35508 18.827 10.5859C18.827 11.8086 18.4168 12.9799 17.6407 13.9732C17.582 14.0484 17.5425 14.1367 17.5257 14.2306C17.5089 14.3244 17.5152 14.421 17.5441 14.5118L18.3511 17.0457L15.8798 15.789Z"
                                          fill="#3C72FC" />
                                       <path
                                          d="M9.99939 11.1719C10.323 11.1719 10.5853 10.9095 10.5853 10.5859C10.5853 10.2623 10.323 10 9.99939 10C9.67579 10 9.41345 10.2623 9.41345 10.5859C9.41345 10.9095 9.67579 11.1719 9.99939 11.1719Z"
                                          fill="#3C72FC" />
                                       <path
                                          d="M12.343 11.1719C12.6666 11.1719 12.929 10.9095 12.929 10.5859C12.929 10.2623 12.6666 10 12.343 10C12.0194 10 11.7571 10.2623 11.7571 10.5859C11.7571 10.9095 12.0194 11.1719 12.343 11.1719Z"
                                          fill="#3C72FC" />
                                       <path
                                          d="M14.6866 11.1719C15.0102 11.1719 15.2726 10.9095 15.2726 10.5859C15.2726 10.2623 15.0102 10 14.6866 10C14.363 10 14.1007 10.2623 14.1007 10.5859C14.1007 10.9095 14.363 11.1719 14.6866 11.1719Z"
                                          fill="#3C72FC" />
                                    </g>
                                    <defs>
                                       <clipPath>
                                          <rect width="20" height="20" fill="white" />
                                       </clipPath>
                                    </defs>
                                 </svg>
                                 <Link href="#0">0 Comments</Link>
                              </li>
                           </ul>
                           <h3><Link href="/blog-details" className="primary-hover">{item.title}</Link></h3>
                           <p className="mt-10">{item.desc}</p>
                           <div className="about__info justify-content-between flex-wrap gap-3 mt-25">
                              <div className="d-flex gap-2 align-items-center">
                                 <Image src={item.avatar ? item.avatar : ""} alt="image" />
                                 <div className="info">
                                    <Link href="#" className="primary-color">By Admin</Link>
                                    <h5>{item.name}</h5>
                                 </div>
                              </div>
                              <Link href="/blog-details" className="btn-one">Read More <i
                                 className="fa-regular fa-arrow-right-long"></i></Link>
                           </div>
                        </div>
                     </div>
                  ))}
                  <ReactPaginate
                     className="pegi justify-content-center mt-60"
                     breakLabel="..."
                     nextLabel={<i className="fa-solid fa-arrow-right-long primary-color transition"></i>}
                     onPageChange={handlePageClick}
                     pageRangeDisplayed={3}
                     pageCount={pageCount}
                     previousLabel={<i className="fa-solid fa-arrow-left-long primary-color transition"></i>}
                     renderOnZeroPageCount={null}
                  />
               </div>
               <div className="col-lg-4 order-1 order-lg-2">
                  <BlogSidebar />
               </div>
            </div>
         </div>
      </section>
   )
}

export default BlogArea
